function ShowDrift(handles)
% Availlable after ZLP alignment. Shows the overall drift of the ZLP in
% each pixel.

%% Get Handles
Axis     = get(handles.Load,'UserData');
Drift    = get(handles.ShowDrift,'UserData');
Zoom     = get(handles.Zoom,'UserData');
Contours = get(handles.Contours,'Value');
Data     = get(handles.CAxisMax,'UserData');
%% Calculate
Drift        = Drift(Zoom(2):Zoom(4),Zoom(1):Zoom(3));
ScaleY       = Axis(1);
ScaleX       = Axis(2);
Drift        = Drift-mean(mean(Drift));
B            = Data{2};
%% Create Images

XMax      = ScaleX*size(Drift,2)/2;
YMax      = ScaleY*size(Drift,1)/2;
AxisX     = linspace(-XMax,XMax,size(Drift,2));
AxisY     = linspace(YMax,-YMax,size(Drift,1));
figure;
imagesc(AxisX,AxisY,Drift);
colormap(hot(255));
colorbar;
xlabel( 'x (nm)' );
ylabel( 'y (nm)' );
title('ZLP Drift Map');
axis equal
set(gca,'FontSize',16);
set(gca,'YDir','normal')

if Contours==1
    hold('on');
    for k = 1:length(B)
        x = B{k}(:,2);
        y = B{k}(:,1);
        plot(x, y, 'b', 'LineWidth', 2);
        xlim([-XMax,XMax]);
        ylim([-YMax,YMax]);
    end
    hold(handles.Axis,'off');
end
clearvars all
end